<div class="table-responsive">
    <table class="table table-striped">
        <tr>
			<?php
            // The base url is the url where we'll pass the filter parameters
            $base_url = array('controller' => 'users', 'action' => 'index');
            echo $this->Form->create('Filter', array(
                'url' => $base_url,
                'inputDefaults' => array(
                    'label' => false,
                    'div' => false,
                    'class' => 'form-control input-sm',
                    'error' => array(
                        'attributes' => array('wrap' => 'span', 'class' => 'help-block')
                    ),
                ),
            ));
            ?>
            <th>
                <?php echo $this->Paginator->sort('User.id', __('ID')); ?> <br>
                <?php echo $this->Form->input('id', array('type' => 'text', 'size' => 3)); ?>
            </th>
            <th>
                <?php echo $this->Paginator->sort('User.username', __('Username')); ?> <br>
                <?php echo $this->Form->input('username', array('type' => 'text', 'size' => 10)); ?>
            </th>
            <th>
                <?php echo $this->Paginator->sort('User.status', __('Status')); ?> <br>
                <?php echo $this->Form->input('status', array('options' => array('Active' => 'Active', 'Inactive' => 'Inactive', 'Banned' => 'Banned'), 'empty' => '', 'default' => '')); ?>
            </th>
            <th>
                <?php echo $this->Paginator->sort('User.email', __('Email')); ?> <br>
                <?php echo $this->Form->input('email', array('type' => 'text')); ?>
            </th>
            <th>
                <?php echo $this->Paginator->sort('User.links', __('Links')); ?> <br>
            </th>
            <th>
                <?php echo $this->Paginator->sort('User.last_login', __('Last Login')); ?> <br>
            </th>
            <th>
                <?php echo $this->Paginator->sort('User.updated', __('Updated')); ?> <br>
            </th>
            <th>
                <?php echo $this->Paginator->sort('User.created', __('Created')); ?> <br>
            </th>
            <th>Actions <br> <?php
                echo $this->Form->submit('Filter');
                echo $this->Html->link('Reset', $base_url);
                ?></th>
            <?php echo $this->Form->end(); ?>
        </tr>
        <?php foreach ($users as $user) : ?>
            <tr>
                <td><?php echo $user['User']['id']; ?></td>
                <td><?php echo $this->Html->link($user['User']['username'], array('action' => 'view', $user['User']['id'])); ?> </td>
                <td><?php echo $user['User']['status']; ?></td>
                <td><?php echo $user['User']['email']; ?></td>
                <td><?php echo $user['User']['links']; ?></td>
                <td><?php echo $user['User']['last_login']; ?></td>
                <td><?php echo $user['User']['updated']; ?></td>
                <td><?php echo $user['User']['created']; ?></td>
                <td>
                    <?php echo $this->Html->link('<i class="fa fa-edit"></i> Edit', array('controller' => 'users', 'action' => 'edit', $user['User']['id']), array('escape' => false, 'class' => 'btn btn-primary btn-xs')); ?> <?php echo $this->Form->postLink('<i class="fa fa-trash-o"></i> Delete', array('action' => 'delete', $user['User']['id']), array('escape' => false, 'class' => 'btn btn-danger btn-xs', 'confirm' => 'Are you sure?')); ?>
                </td>
            </tr>
        <?php endforeach; ?>
        <?php unset($users); ?>
        <?php unset($user); ?>
    </table>
</div>

<ul class="pagination">
    <!-- Shows the previous link -->
    <?php echo $this->Paginator->prev('«', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a')); ?>
    <!-- Shows the page numbers -->
    <?php //echo $this->Paginator->numbers();?>
    <?php
    echo $this->Paginator->numbers(array(
        'modulus' => 4,
        'separator' => '',
        'ellipsis' => '<li><a>...</a></li>',
        'tag' => 'li',
        'currentTag' => 'a',
        'first' => 2,
        'last' => 2
    ));
    ?>
    <!-- Shows the next link -->
    <?php echo $this->Paginator->next('»', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a')); ?>
</ul>
